﻿Copyright (c) (2015) Fluke Corporation                      MET/CAL Procedure
=============================================================================
INSTRUMENT:            Tek RSA3408B: (1 year) VER /9640A-LPN,LFCTR,SWPG,XREF
DATE:                  2016-06-28 14:28:17
AUTHOR:                Fluke
REVISION:              $Revision: 16429 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       1
NUMBER OF LINES:       319
CONFIGURATION:         Fluke 9640A (LPN)
CONFIGURATION:         Fluke 9640A-50
CONFIGURATION:         LF Counter
CONFIGURATION:         Sweep Generator
=============================================================================
#
#  Procedure Author:
#        DFM
#
#  Source:
#        Tektronix RSA3408B 8 GHz Real-Time Spectrum Analyzer Performance
#          Verification and Specifications Manual, Part No. 077-0113-00
#
#  Flexible Standard(s) Required:
#        Synthesized Sweep Generator (SWPG):
#
#          Frequency Range: 10 MHz to 8 GHz, CW
#            Accuracy: ±0.02% (Internal); External Reference capable
#
#          Amplitude Range: -40 dBm to +16 dBm
#            Accuracy: ±1 dB or less
#            Resolution: 0.05 dB
#
#          SSB Phase Noise: <-80 dBc/Hz @ 50 kHz offset
#
#          Example: HP 83630B or equivalent
#
#        LF Counter (LFCTR):
#
#          Ch. A Frequency Range: 10 MHz
#            Accuracy: Based on external frequency standard
#
#          Example: Fluke PM 6690/6xx or equivalent
#
#        Frequency Standard:
#
#          Frequency Range: Suitable for use with configured LF counter
#            Accuracy: ±0.05 ppm or better
#
#  Additional Equipment Required:
#        Power Splitter, 500 MHz to 2 GHz, Isolation >18 dB, Insertion loss:
#          loss: <1 dB, Tracking: ±0.15 dB
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright for this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  IF           0
  1.002  9640         Level = 0 dBm; Freq = 1 GHz; OutputImp = 50 Ohms
  1.002  9640         +PhaseNoise = -110 dBc/Hz; OffsetFreq = 10 kHz; LPN
  1.003  IEEE         [@LFCTR]
  1.004  IEEE         [@SWPG]
  1.005  ENDIF

  1.006  ASK-   R   Q N              P                                     V

  1.007  IF           NOT(VERSIONCHECK("8.0"))
  1.008  END
  1.009  ENDIF

  1.010  CALL         Sub Display Copyright
  1.011  CALL         Sub UUT Connection GPIB

  1.012  HEAD         UUT IDENTIFICATION
  1.013  CALL         Sub IEEE-488.2 Identification Query IEEE

# Make sure correct UUT is connected.
  1.014  IF           NOT(ZCMPI(@ModelNum, "RSA3408B"))
  1.015  HEAD         INCORRECT UUT/PROCEDURE SELECTION!
  1.016  DISP         The UUT and the selected procedure do not match!
  1.016  DISP
  1.016  DISP         The UUT is a [V @Manufacturer] [V @ModelNum] and the
  1.016  DISP         procedure is for an Tektronix RSA3408B.
  1.016  DISP
  1.016  DISP         Please select "Advance" to terminate and select
  1.016  DISP         the proper procedure.
  1.017  END
  1.018  ENDIF

  1.019  CALL         Sub Select Failed Test Mode
  1.020  CALL         Sub Select Verification Method

  1.021  HEAD         PRELIMINARY INSTRUCTIONS
  1.022  DISP         Ensure a minimum UUT warm-up time of at least
  1.022  DISP         20 minutes, in an environment of 10 °C to 40 °C
  1.022  DISP         has been allowed to elapse, prior to proceeding.
  1.022  DISP
  1.022  DISP         Ensure specified warm-up time(s) for required
  1.022  DISP         reference devices has been satisfied.

  1.023  HEAD         CONNECTION INFORMATION
  1.024  OPBR         -z Do you wish to review connector information and
  1.024  OPBR         precautions for the various types of connections
  1.024  OPBR         employed throughout this procedure?
  1.024  OPBR         [NO]

  1.025  IF           MEM1
  1.026  CALL         Sub Connector Precautions (Type N)
  1.027  CALL         Sub Connector Precautions (SMA)
  1.028  CALL         Sub Connector Precautions (3.5 mm)
  1.029  ENDIF

  1.030  CALL         Sub Tek RSA RSA3xxx Installed Options

# Query UUT measurement mode on receipt.
  1.031  SCPI         INST:SEL?[I$]
# Store UUT measurement mode for restoration at procedure completion.
  1.032  MATH         @MeasMode = MEM2
  1.033  SCPI         INST:SEL "SANORMAL";*RST

  1.034  CALL         Sub Initialize /LFCTR
  1.035  CALL         Sub Initialize /SWPG

  1.036  HEAD         EQUIPMENT REQUIREMENTS
# Look up instrument name of external frequency reference.
  1.037  MATH         @FreqRef = INI("startup", "FreqRefDevName")
# Required timebase uncertainty (in ppm).
  1.038  MATH         FreqAcc = 0.05

  1.039  IF           EMPTY(@FreqRef)
  1.040  DISP         No Frequency Reference is currently configured.
  1.040  DISP
  1.040  DISP         Select Configure=>Instrument and ensure that the device
  1.040  DISP         you intend to use as the frequency refenence is
  1.040  DISP         configured.
  1.040  DISP
  1.040  DISP         Then select Configure=>Frequency Reference, and select
  1.040  DISP         that device.
  1.041  END
  1.042  ENDIF

  1.043  OPBR         -z Do you want to REVIEW the list of flexible standards,
  1.043  OPBR         additional equipment and/or accessories required?

  1.044  IF           MEM1
  1.045  HEAD         FLEXIBLE STANDARDS
  1.046  MATH         LF = @LFCTR_Ch1
  1.047  DISP         The minimum use specifications of the following devices,
  1.047  DISP         configured as flexible standards, must be satisfied.
  1.047  DISP
  1.047  DISP         [32]NOMENCLATURE        ALIAS   DEVICE NAME
  1.047  DISP
  1.047  DISP         [32]LF Counter          LFCTR  [V @LFCTR_DevName] [V LF]
  1.047  DISP         [32]Sweep Generator     SWPG   [V @SWPG_DevName]

  1.048  HEAD         -2 LF Counter (LFCTR)
  1.049  OPBR         -z LFCTR: [V @LFCTR_DevName]
  1.049  OPBR
  1.049  OPBR         Minimum Use Specifications:
  1.049  OPBR         [32] Ch. A Frequency Range: 10 MHz
  1.049  OPBR         [32]   Accuracy: Based on external frequency reference
  1.049  OPBR
  1.049  OPBR         [32] (External frequency reference must be configured)
  1.049  OPBR
  1.049  OPBR         Does the [V @LFCTR_DevName] satisfy the above Minimum
  1.049  OPBR         Use Specifications?
  1.050  MATH         LFCTR = MEM1

  1.051  HEAD         -2 (Synthesized) Sweep Generator Sweeper (SWPG)
  1.052  OPBR         -z SWPG: [V @SWPG_DevName]
  1.052  OPBR
  1.052  OPBR         Minimum Use Specifications:
  1.052  OPBR         [32] Frequency Range: 10 MHz to 8 GHz, CW
  1.052  OPBR         [32]   Accuracy: Based on external frequency reference
  1.052  OPBR
  1.052  OPBR         [32] Amplitude Range: -30 dBm to +10 dBm
  1.052  OPBR         [32]   Accuracy: ±1 dB or less
  1.052  OPBR         [32]   Resolution: 0.05 dB
  1.052  OPBR
  1.052  OPBR         [32] (External frequency reference must be configured)
  1.052  OPBR
  1.052  OPBR         [32] SSB Phase Noise, >= 100 kHz offset: <-79 dBc/Hz
  1.052  OPBR
  1.052  OPBR         Does the [V @SWPG_DevName] satisfy the above Minimum
  1.052  OPBR         Use Specifications?
  1.053  MATH         SWPG = MEM1

  1.054  HEAD         -2 External Frequency Reference (XREF)
  1.055  OPBR         -z XREF: [V @FreqRef]
  1.055  OPBR
  1.055  OPBR         Minimum Use Specifications:
  1.055  OPBR         [32]   Accuracy: [V FreqAcc] ppm/year
  1.055  OPBR
  1.055  OPBR         Does the [V @FreqRef] satisfy the above Minimum Use
  1.055  OPBR         Specifications?
  1.056  MATH         XREF = MEM1

  1.057  HEAD         -2

  1.058  IF           NOT(SWPG)
  1.059  DISP         Currently configured SWPG (Sweep Generator):
  1.059  DISP
  1.059  DISP         [32][V @SWPG_DevName]
  1.059  DISP
  1.059  DISP         does not satisfy procedure Minimum Use Specifications.
  1.060  ENDIF

  1.061  IF           NOT(LFCTR)
  1.062  DISP         Currently configured LFCTR (LF Counter):
  1.062  DISP
  1.062  DISP         [32][V @LFCTR_DevName]
  1.062  DISP
  1.062  DISP         does not satisfy procedure Minimum Use Specifications.
  1.063  ENDIF

  1.064  IF           NOT(XREF)
  1.065  DISP         Currently configured XREF (Ext Frequency Reference):
  1.065  DISP
  1.065  DISP         [32][V @FreqRef]
  1.065  DISP
  1.065  DISP         does not satisfy procedure Minimum Use Specifications.
  1.066  ENDIF

  1.067  IF           NOT(SWPG) || NOT(LFCTR) || NOT(XREF)
  1.068  HEAD         FLEXIBLE STANDARD(S) UNSATISFACTORY FOR PROCEDURE USE!
  1.069  DISP         Flexible Standard(s) currently configured for use with
  1.069  DISP         this procedure have been identified as not satisfying
  1.069  DISP         the Minimum Use Specifications.
  1.069  DISP
  1.069  DISP         Select "Advance" to abort procedure, configure suitable
  1.069  DISP         device(s) to replace those identified, then restart the
  1.069  DISP         procedure from the beginning.
  1.070  END
  1.071  ENDIF

  1.072  HEAD         ADDITIONAL EQUIPMENT/ACCESSORIES REQUIRED
  1.073  DISP         - Power Splitter, 500 MHz to 2 GHz, Isolation >18 dB,
  1.073  DISP         [32] Insertion loss: <1 dB, Tracking: ±0.15 dB
  1.073  DISP         - Cable assy., 36", Type "N" (m)-(m), 50 Ohms, DC to
  1.073  DISP         [32] 8 GHz
  1.073  DISP         - Cable assy., 36", BNC (m)-(m), 50 Ohms, 2 ea.
  1.073  DISP         - Adapter, Type "N" (m)-3.5 (m), 50 Ohms, 3 ea., DC to
  1.073  DISP         [32] 8 GHz
  1.073  DISP         - Adapter, Type "N" (m)-3.5 (f), 50 Ohms, DC to
  1.073  DISP         [32] 8 GHz
  1.073  DISP         - Adapter, Type "N" (f)-3.5 (f), 50 Ohms, DC to
  1.073  DISP         [32] 8 GHz
  1.074  ENDIF

  1.075  HEAD         INTERNAL CALIBRATION
  1.076  DISP         Ensure no connections are made to the UUT INPUT 50 Ohms
  1.076  DISP         at this time.
  1.077  SCPI         [T60000]CAL?[I]

# Reset statement for UUT, clearing UUT status register.
  1.078  RESET        *SRE 0;*CLS

  1.079  HEAD         FREQUENCY REFERENCE CONNECTIONS
  1.080  DISP         Make the following connections:
  1.080  DISP
  1.080  DISP         [V @FreqRef] 10 MHz OUT to [V @LFCTR_DevName]
  1.080  DISP         [V @LFCTR_RefIn].
  1.080  DISP
  1.080  DISP         [V @FreqRef] 10 MHz OUT to [V @SWPG_DevName]
  1.080  DISP         [V @SWPG_RefIn].

  1.081  HEAD         LF COUNTER/UUT CONNECTIONS
  1.082  DISP         Make the following connections:
  1.082  DISP
  1.082  DISP         [32]     UUT
  1.082  DISP         [32] (rear panel)  to     [V @LFCTR_DevName]
  1.082  DISP         [32]   REF OUT ---------> [V @LFCTR_Ch1]

  1.083  JMPL         DANL

  1.084  LABEL        FREQUENCY_READOUT
  1.085  CALL         Sub Tek RSA3408B (1 yr) Frequency Readout VER /SWPG,X
  1.086  JMPL         SPURIOUS_SWPG

  1.087  LABEL        FREQUENCY_REFERENCE
  1.088  CALL         Sub Tek RSA3408B (1 yr) 10 MHz Reference VER /LFCTR,X
  1.089  PIC          9640a_to_rsa_input.jpg
  1.090  CALL         Sub Tek RSA3408B (1 yr) Noise Sideband VER /9640-LPN
  1.091  CALL         Sub Tek RSA3408B (1 yr) Absolute Amplitude VER /9640
  1.092  CALL         Sub Tek RSA3408B (1 yr) Input Attenuator VER /9640
  1.093  CALL         Sub Tek RSA3408B (1 yr) Level Linearity VER /9640
  1.094  JMPL         SPURIOUS_9640A

  1.095  LABEL        THIRD_ORDER
  1.096  CALL         Sub Tek RSA3408B (1 yr) Third Order VER /9640,SWPG
  1.097  JMPL         END

  1.098  LABEL        DANL
  1.099  CALL         Sub Tek RSA3408B (1 yr) Displayed Average Noise VER
  1.100  CALL         Sub Tek RSA3408B (1 yr) Residual Response VER
  1.101  JMPL         FREQUENCY_REFERENCE

  1.102  LABEL        SPURIOUS_9640A
  1.103  CALL         Sub Tek RSA3408B (1 yr) Spurious Response VER /9640
  1.104  JMPL         FREQUENCY_READOUT

  1.105  LABEL        SPURIOUS_SWPG
  1.106  CALL         Sub Tek RSA3408B (1 yr) Spurious Response VER /SWPG
  1.107  JMPL         THIRD_ORDER

  1.108  LABEL        END
# Restore instrument measurement mode to 'on receipt'.
  1.109  SCPI         INST:SEL [V @MeasMode]
  1.110  END
